import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.*;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.text.*;
import javafx.scene.control.*;
import javafx.stage.Stage;

public class FontDemo extends Application {
  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {    
    // Tworzenie panelu do przechowywania koła
    Pane pane = new StackPane();
    
    // Tworzenie koła i ustawianie jego właściwości
    Circle circle = new Circle();
    circle.setRadius(50);
    circle.setStroke(Color.BLACK); 
    circle.setFill(new Color(0.5, 0.5, 0.5, 0.1));
    pane.getChildren().add(circle); // Dodawanie koła do panelu

    // Tworzenie etykiety i ustawianie jej właściwości
    Label label = new Label("JavaFX");
    label.setFont(Font.font("Times New Roman", 
      FontWeight.BOLD, FontPosture.ITALIC, 20));
    pane.getChildren().add(label);

    // Tworzenie sceny i dodawanie jej do okna
    Scene scene = new Scene(pane);
    primaryStage.setTitle("FontDemo"); // Ustawianie tytułu okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
  }
  
  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
