import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CollectDemo {
  public static void main(String[] args) {
    String[] names = {"Jan", "Piotr", "Sara", "Kasia", "Julia", 
      "Grzegorz", "Alan", "Sylwia", "Monika", "jan"};
    System.out.println("Liczba znaków we wszystkich imionach łącznie: " +
      Stream.of(names).collect(StringBuilder::new, 
        StringBuilder::append, StringBuilder::append).length());
    
    List<String> list = Stream.of(names).collect(ArrayList::new, 
      ArrayList::add, ArrayList::addAll);
    System.out.println(list);
    
    list = Stream.of(names).collect(Collectors.toList());
    System.out.println(list);

    Set<String> set = Stream.of(names).map(e -> e.toUpperCase()).
      collect(Collectors.toSet());
    System.out.println(set);
    
    Map<String, Integer> map = Stream.of(names).collect(
      Collectors.toMap(e -> e, e -> e.length()));
    System.out.println(map);
    
    System.out.println("Łączna liczba znaków: " +
      Stream.of(names).
        collect(Collectors.summingInt(e -> e.length())));

    java.util.IntSummaryStatistics stats = Stream.of(names).
      collect(Collectors.summarizingInt(e -> e.length()));
    System.out.println("Maksimum: " + stats.getMax());
    System.out.println("Minimum: " + stats.getMin());
    System.out.println("Średnia: "+ stats.getAverage());
  }
}
