import javafx.application.Application;
import javafx.stage.Stage;
import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.util.Duration;

public class ClockAnimation extends Application {
  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    ClockPane clock = new ClockPane(); // Tworzenie zegara

    // Tworzenie obiektu obsługi zdarzeń na potrzeby animacji
    EventHandler<ActionEvent> eventHandler = e -> {
      clock.setCurrentTime(); // Ustawianie nowego czasu w zegarze
    };
    
    // Tworzenie animacji działającego zegara
    Timeline animation = new Timeline(
      new KeyFrame(Duration.millis(1000), eventHandler));
    animation.setCycleCount(Timeline.INDEFINITE);
    animation.play(); // Uruchamianie animacji
    
    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(clock, 250, 250);
    primaryStage.setTitle("ClockAnimation"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
  }

  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
