import java.util.*;
import javafx.geometry.Pos;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;

public class WorldClockControl extends BorderPane {
  // Pobieranie identyfikatorów wszystkich dostępnych ustawień regionalnych i stref czasowych
  private Locale[] availableLocales = Locale.getAvailableLocales();
  private String[] availableTimeZones = TimeZone.getAvailableIDs();

  // Pola kombi do wyświetlania dostępnych ustawień regionalnych i stref czasowych
  private ComboBox<String> cboLocales = new ComboBox<>();
  private ComboBox<String> cboTimeZones = new ComboBox<>();

  // Tworzenie zegara
  private WorldClock clock = new WorldClock();

  public WorldClockControl() {
    // Inicjowanie pola cboLocales wszystkimi dostępnymi ustawieniami regionalnymi
    setAvailableLocales();

    // Inicjowanie pola cboTimeZones wszystkimi dostępnymi strefami czasowymi
    setAvailableTimeZones();

    // Inicjowanie ustawień regionalnych i strefy czasowej
    clock.setLocale(
      availableLocales[cboLocales.getSelectionModel()
        .getSelectedIndex()]);
    clock.setTimeZone(TimeZone.getTimeZone(
      availableTimeZones[cboTimeZones.getSelectionModel()
        .getSelectedIndex()]));

    GridPane pane = new GridPane();
    pane.setHgap(5);
    pane.add(new Label("Ust. region."), 0, 0);
    pane.add(new Label("Strefa czas."), 0, 1);
    pane.add(cboLocales, 1, 0);
    pane.add(cboTimeZones, 1, 1);

    setTop(pane);
    setCenter(clock);
    BorderPane.setAlignment(pane, Pos.CENTER);
    BorderPane.setAlignment(clock, Pos.CENTER);

    cboLocales.setOnAction(e ->
      clock.setLocale(availableLocales[cboLocales.
        getSelectionModel().getSelectedIndex()]));
    cboTimeZones.setOnAction(e ->
      clock.setTimeZone(TimeZone.getTimeZone(
        availableTimeZones[cboTimeZones.
          getSelectionModel().getSelectedIndex()])));
  }

  private void setAvailableLocales() {
    for (int i = 0; i < availableLocales.length; i++) 
      cboLocales.getItems().add(availableLocales[i]
       .getDisplayName() + " " + availableLocales[i].toString());

    cboLocales.getSelectionModel().selectFirst();
  }

  private void setAvailableTimeZones() {
    // Sortowanie stref czasowych
    Arrays.sort(availableTimeZones);
    for (int i = 0; i < availableTimeZones.length; i++) {
      cboTimeZones.getItems().add(availableTimeZones[i]);
    }
    cboTimeZones.getSelectionModel().selectFirst();
  }
}
