public class TaskThreadDemo {
  public static void main(String[] args) {
    // Tworzenie zadań
    Runnable printA = new PrintChar('a', 100);
    Runnable printB = new PrintChar('b', 100);
    Runnable print100 = new PrintNum(100);

    // Tworzenie wątków
    Thread thread1 = new Thread(printA);
    Thread thread2 = new Thread(printB);
    Thread thread3 = new Thread(print100);

    // Uruchamianie wątków
    thread1.start();
    thread2.start();
    thread3.start();
  }
}

// Zadanie wyświetlające znak określoną liczbę razy
class PrintChar implements Runnable {
  private char charToPrint; // Wyświetlany znak
  private int times; // Liczba wyświetleń

  /** Tworzy zadanie z określonym znakiem i liczbą
    * wyświetleń tego znaku
   */
  public PrintChar(char c, int t) {
    charToPrint = c;
    times = t;
  }

  @Override /** Przesłanianie metody run() informującej
              * system o tym, jakie zadanie należy wykonać
   */
  public void run() {
    for (int i = 0; i < times; i++) {
      System.out.print(charToPrint);
    }
  }
}

// Klasa zadania wyświetlająca liczby od 1 do n dla danego n
class PrintNum implements Runnable {
  private int lastNum;

  /** Tworzy zadanie wyświetlające liczby 1, 2, …, n */
  public PrintNum(int n) {
    lastNum = n;
  }

  @Override /** Informuje wątek, jak uruchamiać zadanie */
  public void run() {
    for (int i = 1; i <= lastNum; i++) {
      System.out.print(" " + i);
    }
  }
}
