import java.io.*;
import java.net.*;

public class StudentServer {
  private ObjectOutputStream outputToFile;
  private ObjectInputStream inputFromClient;

  public static void main(String[] args) {
    new StudentServer();
  }

  public StudentServer() {
    try {
      // Tworzenie gniazda serwera
      ServerSocket serverSocket = new ServerSocket(8001);
      System.out.println("Serwer został uruchomiony ");

      // Tworzenie strumienia wyjściowego obiektów
      outputToFile = new ObjectOutputStream(
        new FileOutputStream("student.dat", true));

      while (true) {
        // Oczekiwanie na żądanie nawiązania połączenia
        Socket socket = serverSocket.accept();

        // Tworzenie strumienia wejściowego z użyciem gniazda
        inputFromClient =
          new ObjectInputStream(socket.getInputStream());

        // Odczyt ze strumienia wejściowego
        Object object = inputFromClient.readObject();

        // Zapis w pliku
        outputToFile.writeObject(object);
        System.out.println("Zapisano nowy obiekt z danymi studenta");
      }
    }
    catch(ClassNotFoundException ex) {
      ex.printStackTrace();
    }
    catch(IOException ex) {
      ex.printStackTrace();
    }
    finally {
      try {
        inputFromClient.close();
        outputToFile.close();
      }
      catch (Exception ex) {
        ex.printStackTrace();
      }
    }
  }
}
