public class StackOfIntegers {
  private int[] elements;
  private int size;
  public static final int DEFAULT_CAPACITY = 16;

  /** Tworzenie stosu o pojemności domyślnej 16 elementów */
  public StackOfIntegers() {
    this(DEFAULT_CAPACITY);
  }

  /** Tworzenie stosu o określonej pojemności */
  public StackOfIntegers(int capacity) {
    elements = new int[capacity];
  }

  /** Umieszcza nową liczbę całkowitą na wierzchołku stosu */
  public void push(int value) {
    if (size >= elements.length) {
      int[] temp = new int[elements.length * 2];
      System.arraycopy(elements, 0, temp, 0, elements.length);
      elements = temp;
    }

    elements[size++] = value;
  }

  /** Zwraca wierzchołek i usuwa go ze stosu */
  public int pop() {
    return elements[--size];
  }

  /** Zwraca wierzchołek stosu */
  public int peek() {
    return elements[size - 1];
  }

  /** Sprawdza, czy stos jest pusty */
  public boolean empty() {
    return size == 0;
  }

  /** Zwraca liczbę elementów na stosie */
  public int getSize() {
    return size;
  }
}
