import java.util.IntSummaryStatistics;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class IntStreamDemo {
  public static void main(String[] args) {
    int[] values = {3, 4, 1, 5, 20, 1, 3, 3, 4, 6};
    
    System.out.println("Średnia unikatowych liczb parzystych > 3: " +
      IntStream.of(values).distinct()
        .filter(e -> e > 3 && e % 2 == 0).average().getAsDouble());
    
    System.out.println("Suma pierwszych 4 liczb: " +
      IntStream.of(values).limit(4).sum());
    
    IntSummaryStatistics stats = 
      IntStream.of(values).summaryStatistics();

    System.out.printf("Podsumowanie strumienia:\n%-10s%10d\n" +
      "%-10s%10d\n%-10s%10d\n%-10s%10d\n%-10s%10.2f\n",
      " Liczba elementów:", stats.getCount(), " Maksimum:", stats.getMax(),
      " Minimum:", stats.getMin(), " Suma:", stats.getSum(),
      " Średnia:", stats.getAverage());
    
    String[] names = {"Jan", "Piotr", "Sara", "Kasia", "Julia", 
      "Grzegorz", "Alan", "Sylwia", "Monika", "jan"};
    
    System.out.println("Łączna liczba znaków we wszystkich imionach: "
      + Stream.of(names).mapToInt(e -> e.length()).sum());

    System.out.println("Liczba cyfr w tablicy values: " +
      IntStream.of(values).mapToObj(e -> e + "")
        .mapToInt(e -> e.length()).sum());
  }
}
