import java.io.*;
import java.net.*;
import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;

public class Client extends Application {
  // Strumienie wejściowy i wyjściowy
  DataOutputStream toServer = null;
  DataInputStream fromServer = null;

  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {
	// Panel p przechowuje etykietę i pole tekstowe
    BorderPane paneForTextField = new BorderPane();
    paneForTextField.setPadding(new Insets(5, 5, 5, 5)); 
    paneForTextField.setStyle("-fx-border-color: green");
    paneForTextField.setLeft(new Label("Podaj promień: "));
    
    TextField tf = new TextField();
    tf.setAlignment(Pos.BOTTOM_RIGHT);
    paneForTextField.setCenter(tf);
    
    BorderPane mainPane = new BorderPane();
	// Obszar tekstowy do wyświetlania tekstu
    TextArea ta = new TextArea();
    mainPane.setCenter(new ScrollPane(ta));
    mainPane.setTop(paneForTextField);
    
	// Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(mainPane, 450, 200);
    primaryStage.setTitle("Client"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
    
    tf.setOnAction(e -> {
      try {
		// Pobieranie promienia z pola tekstowego
        double radius = Double.parseDouble(tf.getText().trim());
  
		// Przekazywanie promienia na serwer
        toServer.writeDouble(radius);
        toServer.flush();
  
		// Pobieranie powierzchni z serwera
        double area = fromServer.readDouble();
  
		// Wyświetlanie danych w obszarze tekstowym
        ta.appendText("Promień: " + radius + "\n");
        ta.appendText("Powierzchnia z serwera: "
          + area + '\n');
      }
      catch (IOException ex) {
        System.err.println(ex);
      }
    });
  
    try {
	  // Tworzenie gniazda na potrzeby połączenia z serwerem
      Socket socket = new Socket("localhost", 8000);
      // Socket socket = new Socket("130.254.204.36", 8000);
      // Socket socket = new Socket("drake.Armstrong.edu", 8000);

	  // Tworzenie strumienia wejściowego na potrzeby pobierania danych z serwera
      fromServer = new DataInputStream(socket.getInputStream());

	  // Tworzenie strumienia wyjściowego na potrzeby przesyłania danych na serwer
      toServer = new DataOutputStream(socket.getOutputStream());
    }
    catch (IOException ex) {
      ta.appendText(ex.toString() + '\n');
    }
  }

  /**
  * Metoda main jest potrzebna tylko w IDE z ograniczoną obsługą
  * JavaFX. Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
