public class CircleWithPrivateDataFields {
  /** Promień koła */
  private double radius = 1;

  /** Liczba utworzonych obiektów */
  private static int numberOfObjects = 0;

  /** Tworzy koło o promieniu 1 */
  public CircleWithPrivateDataFields() {
    numberOfObjects++;
  }

  /** Tworzy koło o podanym promieniu */
  public CircleWithPrivateDataFields(double newRadius) {
    radius = newRadius;
    numberOfObjects++;
  }

  /** Zwraca promień */
  public double getRadius() {
    return radius;
  }

  /** Ustawia nowy promień */
  public void setRadius(double newRadius) {
    radius = (newRadius >= 0) ? newRadius : 0;
  }

  /** Zwraca wartość numberOfObjects */
  public static int getNumberOfObjects() {
    return numberOfObjects;
  }

  /** Zwraca powierzchnię koła */
  public double getArea() {
    return radius * radius * Math.PI;
  }
}
