import javafx.application.Application;
import javafx.geometry.Pos;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;

public class BSTAnimation extends Application {
  @Override // Przesanianie metody start w klasie Application
  public void start(Stage primaryStage) {
    BST<Integer> tree = new BST<>(); // Tworzenie drzewa

    BorderPane pane = new BorderPane();
    BTView view = new BTView(tree); // Tworzenie obiektu BTView
    pane.setCenter(view);

    TextField tfKey = new TextField();
    tfKey.setPrefColumnCount(3);
    tfKey.setAlignment(Pos.BASELINE_RIGHT);
    Button btInsert = new Button("Wstaw");
    Button btDelete = new Button("Usu");
    HBox hBox = new HBox(5);
    hBox.getChildren().addAll(new Label("Podaj klucz: "),
      tfKey, btInsert, btDelete);
    hBox.setAlignment(Pos.CENTER);
    pane.setBottom(hBox);

    btInsert.setOnAction(e -> {
      int key = Integer.parseInt(tfKey.getText());
      if (tree.search(key)) { // Klucz ju znajduje si w drzewie
        view.displayTree();
        view.setStatus(key + " ju znajduje si w drzewie");
      }
      else {
        tree.insert(key); // Wstawianie nowego klucza
        view.displayTree();
        view.setStatus(key + " zosta wstawiony");
      }
    });

    btDelete.setOnAction(e -> {
      int key = Integer.parseInt(tfKey.getText());
      if (!tree.search(key)) { // Klucza nie ma w drzewie
        view.displayTree();
        view.setStatus(key + " nie wystpuje w drzewie");
      }
      else {
        tree.delete(key); // Usuwanie klucza
        view.displayTree();
        view.setStatus(key + " zosta usunity z drzewa");
      }
    });

    // Tworzenie sceny i umieszczanie panelu w oknie
    Scene scene = new Scene(pane, 450, 250);
    primaryStage.setTitle("BSTAnimation"); // Nagwek
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wywietlanie okna
  }

  /**
  * Metoda main jest potrzebna tylko w IDE z ograniczon obsug
  * JavaFX. Nie jest potrzebna przy uruchamianiu kodu w wierszu polece.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
