public class WeightedEdge extends Edge
    implements Comparable<WeightedEdge> {
  public double weight; // Waga krawędzi (u, v)

  /** Tworzenie krawędzi z wagą (u, v) */
  public WeightedEdge(int u, int v, double weight) {
    super(u, v);
    this.weight = weight;
  }

  @Override /** Porównanie dwóch krawędzi według wag */
  public int compareTo(WeightedEdge edge) {
    if (weight > edge.weight) {
      return 1;
    }
    else if (weight == edge.weight) {
      return 0;
    }
    else {
      return -1;
    }
  }
}
