import java.util.Collection;

public interface Tree<E> extends Collection<E> {
  /** Zwraca true, jeśli element znajduje się w drzewie */
  public boolean search(E e);

  /** Wstawia element e do drzewa binarnego.
    * Zwraca true, jeśli element został wstawiony */
  public boolean insert(E e);

  /** Usuwa podany element z drzewa.
    * Zwraca true, jeśli element został usunięty */
  public boolean delete(E e);
  
  /** Zwraca liczbę elementów w drzewie */
  public int getSize();
  
  /** Przechodzenie drzewa metodą inorder od korzenia */
  public default void inorder() {
  }

  /** Przechodzenie drzewa metodą postorder od korzenia */
  public default void postorder() {
  }

  /** Przechodzenie drzewa metodą preorder od korzenia */
  public default void preorder() {
  }
  
  @Override /** Zwraca true, jeśli drzewo jest puste */
  public default boolean isEmpty() {
    return this.size() == 0;
  }

  @Override
  public default boolean contains(Object e) {
    return search((E)e);
  }
  
  @Override
  public default boolean add(E e) {
    return insert(e);
  }
  
  @Override
  public default boolean remove(Object e) {
    return delete((E)e);
  }
  
  @Override
  public default int size() {
    return getSize();
  }
  
  @Override
  public default boolean containsAll(Collection<?> c) {
    // Ćwiczenie dla czytelników
    return false;
  }

  @Override
  public default boolean addAll(Collection<? extends E> c) {
    // Ćwiczenie dla czytelników
    return false;
  }

  @Override
  public default boolean removeAll(Collection<?> c) {
    // Ćwiczenie dla czytelników
    return false;
  }

  @Override
  public default boolean retainAll(Collection<?> c) {
    // Ćwiczenie dla czytelników
    return false;
  }

  @Override
  public default Object[] toArray() {
    // Ćwiczenie dla czytelników
    return null;
  }

  @Override
  public default <T> T[] toArray(T[] array) {
    // Ćwiczenie dla czytelników
    return null;
  }
}