import java.util.Scanner;

public class PrimeNumbers {
  public static void main(String[] args) {
    Scanner input = new Scanner(System.in);
    System.out.print("Znajduje wszystkie liczby pierwsze <= n. Podaj n: ");
    int n = input.nextInt();

    final int NUMBER_PER_LINE = 10; // Wyświetla 10 liczb w wierszu
    int count = 0; // Zlicza liczby pierwsze
    int number = 2; // Sprawdzana liczba

    System.out.println("Liczby pierwsze:");

    // Wielokrotnie znajduje liczby pierwsze
    while (number <= n) {
      // Założenie, że liczba jest pierwsza
      boolean isPrime = true; // Czy sprawdzana liczba jest pierwsza?

      // Sprawdzanie, czy liczba jest pierwsza
      for (int divisor = 2; divisor <= (int)(Math.sqrt(number)); 
          divisor++) {
        if (number % divisor == 0) { // Jeśli ma wartość true, liczba nie jest pierwsza
          isPrime = false; // Ustawianie isPrime na wartość false
          break; // Wyjście z pętli for
        }
      }

      // Wyświetlanie liczby pierwszej i zwiększanie wartości licznika
      if (isPrime) {
        count++; // Zwiększanie wartości licznika

        if (count % NUMBER_PER_LINE == 0) {
          // Wyświetlanie liczby i przejście do następnego wiersza
          System.out.printf("%7d\n", number);
        }
        else
          System.out.printf("%7d", number);
      }

      // Sprawdzanie, czy następna liczba jest pierwsza
      number++;
    }
    
    System.out.println("\n" + "Ile liczb pierwszych mniejszych lub równych " +
       n + "? " + count);
  }
}
