import java.util.*;
import java.io.*;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.scene.text.Text;

public class EncodingDemo extends Application {
  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) throws Exception {
    try (
      PrintWriter output = new PrintWriter("temp.txt", "GB18030");
    ) {
      output.print("\u6B22\u8FCE Welcome \u03b1\u03b2\u03b3");
    }

    try (
      Scanner input = new Scanner(new File("temp.txt"), "GB18030");
    ) {
      StackPane pane = new StackPane();
      pane.getChildren().add(new Text(input.nextLine()));
      
      // Tworzenie sceny i umieszczanie jej w oknie
      Scene scene = new Scene(pane, 200, 200);
      primaryStage.setTitle("EncodingDemo"); // Ustawianie nagłówka okna
      primaryStage.setScene(scene); // Umieszczanie sceny w oknie
      primaryStage.show(); // Wyświetlanie okna
    }
  }
  
  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}