import java.rmi.*;
import java.rmi.server.*;

public class CallBackImpl extends UnicastRemoteObject
    implements CallBack {
  // Serwer będzie kierował wywołania do klienta za pomocą wywołań zwrotnych
  private TicTacToeClientRMI thisClient;

  /** Konstruktor */
  public CallBackImpl(Object client) throws RemoteException {
    thisClient = (TicTacToeClientRMI)client;
  }

  /** Serwer powiadamia klienta o jego ruchu */
  public void takeTurn(boolean turn) throws RemoteException {
    thisClient.setMyTurn(turn);
  }

  /** Serwer przesyła komunikat wyświetlany przez klienta */
  public void notify(String message) throws RemoteException {
    thisClient.setMessage(message);
  }

  /** Serwer powiadamia klienta o ruchu przeciwnika */
  public void mark(int row, int column, char token)
      throws RemoteException {
    thisClient.mark(row, column, token);
  }
}
