public class TestEdible {
  public static void main(String[] args) {
    Object[] objects = {new Tiger(), new Chicken(), new Apple()};
    for (int i = 0; i < objects.length; i++) {
      if (objects[i] instanceof Edible)
        System.out.println(((Edible)objects[i]).howToEat());

      if (objects[i] instanceof Animal) {
        System.out.println(((Animal)objects[i]).sound());
      }
    }
  }
}

abstract class Animal {
  private double weight;
  
  public double getWeight() {
    return weight;
  }
  
  public void setWeight(double weight) {
    this.weight = weight;
  }
  
  /** Zwraca odgłos zwierzęcia */
  public abstract String sound();
}

class Chicken extends Animal implements Edible {
  @Override
  public String howToEat() {
    return "Kurczak: usmaż go";
  }
    
  @Override
  public String sound() {
    return "Kurczak: ko-ko-ko";
  }
}

class Tiger extends Animal {
  @Override
  public String sound() {
    return "Tygrys: wrrrr";
  }
}

abstract class Fruit implements Edible {
  // Pola, konstruktory i metody zostały pominięte
}

class Apple extends Fruit {
  @Override
  public String howToEat() {
    return "Jabłko: zrób cydr";
  }
}

class Orange extends Fruit {
  @Override
  public String howToEat() {
    return "Pomarańcza: zrób sok pomarańczowy";
  }
}
