import javafx.application.Application;
import javafx.stage.Stage;
import javafx.geometry.Orientation;
import javafx.scene.Scene;
import javafx.scene.control.ScrollBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;

public class ScrollBarDemo extends Application {
  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    Text text = new Text(20, 20, "Programowanie z JavaFX");
    
    ScrollBar sbHorizontal = new ScrollBar();
    ScrollBar sbVertical = new ScrollBar();
    sbVertical.setOrientation(Orientation.VERTICAL);
    
    // Umieszczanie tekstu w panelu
    Pane paneForText = new Pane();
    paneForText.getChildren().add(text);
    
    // Tworzenie panelu BorderPane do przechowywania tekstu i pasków przewijania
    BorderPane pane = new BorderPane();
    pane.setCenter(paneForText);
    pane.setBottom(sbHorizontal);
    pane.setRight(sbVertical);

    // Odbiornik reagujący na zmianę wartości poziomego paska przewijania
    sbHorizontal.valueProperty().addListener(ov -> 
      text.setX(sbHorizontal.getValue() * paneForText.getWidth() /
        sbHorizontal.getMax()));
    
    // Odbiornik reagujący na zmianę wartości pionowego paska przewijania
    sbVertical.valueProperty().addListener(ov -> 
      text.setY(sbVertical.getValue() * paneForText.getHeight() /
        sbVertical.getMax()));
    
    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(pane, 450, 170);
    primaryStage.setTitle("ScrollBarDemo"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
  }

  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
