import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;

public class ParallelStreamDemo {
  public static void main(String[] args) {
    Random random = new Random();  
    int[] list = random.ints(200_000_000).toArray();
    
    System.out.println("Liczba procesorów: " +
      Runtime.getRuntime().availableProcessors());
    
    long startTime = System.currentTimeMillis();
    int[] list1 = IntStream.of(list).filter(e -> e > 0).sorted()
      .limit(5).toArray();
    System.out.println(Arrays.toString(list1));
    long endTime = System.currentTimeMillis();
    System.out.println("Czas przetwarzania sekwencyjnego: " +
      (endTime − startTime) + " ms");

    startTime = System.currentTimeMillis();
    int[] list2 = IntStream.of(list).parallel().filter(e -> e > 0)
      .sorted().limit(5).toArray();
    System.out.println(Arrays.toString(list2));
    endTime = System.currentTimeMillis();
    System.out.println("Czas przetwarzania równoległego: " +
      (endTime − startTime) + " ms");
  }
}
