import javafx.geometry.Insets;
import javafx.scene.control.Label;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Font;

public class DescriptionPane extends BorderPane {
  /** Etykieta do wyświetlania obrazu i podpisu */
  private Label lblImageTitle = new Label();

  /** Obszar tekstowy do wyświetlania tekstu */
  private TextArea taDescription = new TextArea();
  
  public DescriptionPane() {
    // Wyśrodkowanie ikony i tekstu oraz umieszczenie tekstu pod ikoną
    lblImageTitle.setContentDisplay(ContentDisplay.TOP);
    lblImageTitle.setPrefSize(200,  100);
    
    // Ustawianie czcionki dla etykiety i obszaru tekstowego
    lblImageTitle.setFont(new Font("SansSerif", 16));
    taDescription.setFont(new Font("Serif", 14));
    
    taDescription.setWrapText(true);
    taDescription.setEditable(false);

    // Tworzenie panelu ScrollPane do przechowywania obszaru tekstowego
    ScrollPane scrollPane = new ScrollPane(taDescription);

    // Umieszczanie etykiety i panelu ScrollPane w panelu BorderPane
    setLeft(lblImageTitle);
    setCenter(scrollPane);
    setPadding(new Insets(5, 5, 5, 5));
  }
  
  /** Ustawianie podpisu */
  public void setTitle(String title) {
    lblImageTitle.setText(title);
  }

  /** Konfigurowanie widoku */
  public void setImageView(ImageView icon) {
    lblImageTitle.setGraphic(icon);
  }

  /** Podawanie opisu */
  public void setDescription(String text) {
    taDescription.setText(text);
  }
}