import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.control.Slider;
import javafx.scene.layout.BorderPane;

public class BounceBallSlider extends Application {
  @Override // Przesanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    BallPane ballPane = new BallPane();
    Slider slSpeed = new Slider();
    slSpeed.setMax(20);
    ballPane.rateProperty().bind(slSpeed.valueProperty());

    BorderPane pane = new BorderPane();
    pane.setCenter(ballPane);
    pane.setBottom(slSpeed);

    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(pane, 250, 250);
    primaryStage.setTitle("BounceBallSlider"); // Nagwek
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wywietlanie okna
  }

  /**
  * Metoda main jest potrzebna tylko w IDE z ograniczon obsug
  * JavaFX. Nie jest potrzebna przy uruchamianiu kodu w wierszu polece.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
