import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.text.Text;

public class BTView extends Pane {
  private BST<Integer> tree = new BST<>();
  private double radius = 15; // Promie wza drzewa
  private double vGap = 50; // Odlego midzy poziomami drzewa

  BTView(BST<Integer> tree) {
    this.tree = tree;
    setStatus("Drzewo jest puste");
  }

  public void setStatus(String msg) {
    getChildren().add(new Text(20, 20, msg));
  }

  public void displayTree() {
    this.getChildren().clear(); // Oprnianie panelu
    if (tree.getRoot() != null) {
      // Rekurencyjne wywietlanie drzewa
      displayTree(tree.getRoot(), getWidth() / 2, vGap,
        getWidth() / 4);
    }
  }

  /** Wywietlanie poddrzewa z korzeniem na pozycji (x, y) */
  private void displayTree(BST.TreeNode<Integer> root,
      double x, double y, double hGap) {
    if (root.left != null) {
      // Rysowanie linii do lewego wza
      getChildren().add(new Line(x - hGap, y + vGap, x, y));
      // Rekurencyjne rysowanie lewego poddrzewa
      displayTree(root.left, x - hGap, y + vGap, hGap / 2);
    }

    if (root.right != null) {
      // Rysowanie linii do prawego wza
      getChildren().add(new Line(x + hGap, y + vGap, x, y));
      // Rekurencyjne rysowanie prawego poddrzewa
      displayTree(root.right, x + hGap, y + vGap, hGap / 2);
    }

    // Wywietlanie wza
    Circle circle = new Circle(x, y, radius);
    circle.setFill(Color.WHITE);
    circle.setStroke(Color.BLACK);
    getChildren().addAll(circle,
      new Text(x - 4, y + 4, root.element + ""));
  }
}
