/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;

public class Loan {
    private double annualInterestRate;
    private int numberOfYears;
    private double loanAmount;
    private Date loanDate;

    public Loan() {
        this(2.5, 1, 1000.0);
    }

    public Loan(double annualInterestRate, int numberOfYears, double loanAmount) {
        this.annualInterestRate = annualInterestRate;
        this.numberOfYears = numberOfYears;
        this.loanAmount = loanAmount;
        this.loanDate = new Date();
    }

    public double getAnnualInterestRate() {
        return this.annualInterestRate;
    }

    public void setAnnualInterestRate(double annualInterestRate) {
        this.annualInterestRate = annualInterestRate;
    }

    public int getNumberOfYears() {
        return this.numberOfYears;
    }

    public void setNumberOfYears(int numberOfYears) {
        this.numberOfYears = numberOfYears;
    }

    public double getLoanAmount() {
        return this.loanAmount;
    }

    public void setLoanAmount(double loanAmount) {
        this.loanAmount = loanAmount;
    }

    public double getMonthlyPayment() {
        double monthlyInterestRate = this.annualInterestRate / 1200.0;
        double monthlyPayment = this.loanAmount * monthlyInterestRate / (1.0 - 1.0 / Math.pow(1.0 + monthlyInterestRate, this.numberOfYears * 12));
        return monthlyPayment;
    }

    public double getTotalPayment() {
        double totalPayment = this.getMonthlyPayment() * (double)this.numberOfYears * 12.0;
        return totalPayment;
    }

    public Date getLoanDate() {
        return this.loanDate;
    }
}

