/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;

class TimestampAccessor
extends DateTimeCommonAccessor {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:30:28_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    TimestampAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        this.init(oracleStatement, 180, 180, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    TimestampAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 180, 180, s2, false);
        this.initForDescribe(180, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 11;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    @Override
    String getString(int n2) throws SQLException {
        String string = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            int n3 = this.columnIndex + this.byteLength * n2;
            int n4 = ((this.rowSpaceByte[0 + n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
            int n5 = -1;
            if (s2 == 11) {
                n5 = this.oracleNanos(n3);
            }
            int n6 = 0;
            n6 = this.rowSpaceByte[4 + n3] - 1;
            string = this.toText(n4, this.rowSpaceByte[2 + n3], this.rowSpaceByte[3 + n3], n6, this.rowSpaceByte[5 + n3] - 1, this.rowSpaceByte[6 + n3] - 1, n5, n6 < 12, null);
        }
        return string;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        Serializable serializable = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            if (this.externalType == 0) {
                serializable = this.statement.connection.j2ee13Compliant ? this.getTimestamp(n2) : this.getTIMESTAMP(n2);
            } else {
                switch (this.externalType) {
                    case 93: {
                        return this.getTimestamp(n2);
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return serializable;
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getTIMESTAMP(n2);
    }

    @Override
    Object getObject(int n2, Map map) throws SQLException {
        return this.getObject(n2);
    }
}

