/*
 * Decompiled with CFR 0.152.
 */
package chapter41;

import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import myWebservice.ScoreService;
import myWebservice.ScoreWebService;

public class FindScoreApp
extends Application {
    private ScoreWebService scoreWebService = new ScoreWebService();
    private ScoreService proxy = this.scoreWebService.getScoreServicePort();
    private Button btGetScore = new Button("Get Score");
    private TextField tfName = new TextField();
    private TextField tfScore = new TextField();

    public void start(Stage primaryStage) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.add((Node)new Label("Name"), 0, 0);
        gridPane.add((Node)new Label("Score"), 0, 1);
        gridPane.add((Node)this.tfName, 1, 0);
        gridPane.add((Node)this.tfScore, 1, 1);
        gridPane.add((Node)this.btGetScore, 1, 2);
        Scene scene = new Scene((Parent)gridPane, 250.0, 250.0);
        primaryStage.setTitle("FindScoreApp");
        primaryStage.setScene(scene);
        primaryStage.show();
        this.btGetScore.setOnAction(e -> this.getScore());
    }

    private void getScore() {
        try {
            double score = this.proxy.findScore(this.tfName.getText().trim());
            if (score < 0.0) {
                this.tfScore.setText("Not found");
            } else {
                this.tfScore.setText(new Double(score).toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        FindScoreApp.launch((String[])args);
    }
}

