/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.converter.CharacterConverterJDBC;

public class CharacterConverter1Byte
extends CharacterConverterJDBC {
    static final long serialVersionUID = 200017349723606452L;
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    public int m_ucsReplacement = 0;
    public int[] m_ucsChar = null;
    public char[] m_oraCharLevel1 = null;
    public char[] m_oraCharSurrogateLevel = null;
    public char[] m_oraCharLevel2 = null;
    public byte m_oraCharReplacement = 0;
    protected transient boolean noSurrogate = true;
    protected transient boolean strictASCII = true;
    protected transient int m_oraCharLevel2Size = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:30:28_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public CharacterConverter1Byte() {
        this.m_groupId = 0;
    }

    int toUnicode(byte by) throws SQLException {
        int n2 = this.m_ucsChar[by & 0xFF];
        if (n2 == -1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 154);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return n2;
    }

    int toUnicodeWithReplacement(byte by) {
        int n2 = this.m_ucsChar[by & 0xFF];
        if (n2 == -1) {
            return this.m_ucsReplacement;
        }
        return n2;
    }

    byte toOracleCharacter(char c2, char c3) throws SQLException {
        int n2 = c2 >>> 8 & 0xFF;
        int n3 = c2 & 0xFF;
        int n4 = c3 >>> 8 & 0xFF;
        int n5 = c3 & 0xFF;
        if (this.m_oraCharLevel1[n2] != (char)this.m_oraCharLevel2Size && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5] != '\uffff') {
            return (byte)this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5];
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 155);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    byte toOracleCharacter(char c2) throws SQLException {
        int n2 = c2 >>> 8;
        int n3 = c2 & 0xFF;
        char c3 = this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n3];
        if (c3 != '\uffff') {
            return (byte)c3;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 155);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    byte toOracleCharacterWithReplacement(char c2, char c3) {
        int n2 = c2 >>> 8 & 0xFF;
        int n3 = c2 & 0xFF;
        int n4 = c3 >>> 8 & 0xFF;
        int n5 = c3 & 0xFF;
        if (this.m_oraCharLevel1[n2] != (char)this.m_oraCharLevel2Size && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5] != '\uffff') {
            return (byte)this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5];
        }
        return this.m_oraCharReplacement;
    }

    byte toOracleCharacterWithReplacement(char c2) {
        int n2 = c2 >>> 8;
        int n3 = c2 & 0xFF;
        char c3 = this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n3];
        if (c3 != '\uffff') {
            return (byte)c3;
        }
        return this.m_oraCharReplacement;
    }

    @Override
    public int toUnicodeChars(byte[] byArray, int n2, char[] cArray, int n3, int n4) throws SQLException {
        int n5;
        int n6 = n2 + n4;
        int n7 = 0;
        int n8 = n3;
        for (n5 = n2; n5 < n6 && n8 < cArray.length; ++n5) {
            n7 = this.m_ucsChar[byArray[n5] & 0xFF];
            if (n7 == this.m_ucsReplacement) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 154);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (((long)n7 & 0xFFFFFFFFL) > 65535L) {
                if (n8 + 2 < cArray.length) {
                    --n5;
                    break;
                }
                cArray[n8++] = (char)(n7 >>> 16);
                cArray[n8++] = (char)(n7 & 0xFFFF);
                continue;
            }
            cArray[n8++] = (char)n7;
        }
        return n5;
    }

    @Override
    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = n2 + n3;
        StringBuffer stringBuffer = new StringBuffer(n3);
        int n5 = 0;
        for (int i2 = n2; i2 < n4; ++i2) {
            n5 = this.m_ucsChar[byArray[i2] & 0xFF];
            if (n5 == this.m_ucsReplacement) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 154);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (((long)n5 & 0xFFFFFFFFL) > 65535L) {
                stringBuffer.append((char)(n5 >>> 16));
                stringBuffer.append((char)(n5 & 0xFFFF));
                continue;
            }
            stringBuffer.append((char)n5);
        }
        return stringBuffer.toString();
    }

    @Override
    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        StringBuffer stringBuffer = new StringBuffer(n3);
        int n5 = 0;
        for (int i2 = n2; i2 < n4; ++i2) {
            n5 = this.m_ucsChar[byArray[i2] & 0xFF];
            if (n5 == -1) {
                stringBuffer.append((char)this.m_ucsReplacement);
                continue;
            }
            stringBuffer.append((char)n5);
        }
        return stringBuffer.toString();
    }

    @Override
    public byte[] toOracleString(String string) throws SQLException {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (cArray[i2] >= '\ud800' && cArray[i2] < '\udc00') {
                if (i2 + 1 < n2 && cArray[i2 + 1] >= '\udc00' && cArray[i2 + 1] <= '\udfff') {
                    if (this.noSurrogate) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 155);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    byArray[n3++] = this.toOracleCharacter(cArray[i2], cArray[i2 + 1]);
                    ++i2;
                    continue;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 155);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            byArray[n3++] = cArray[i2] < '\u0080' && this.strictASCII ? (byte)cArray[i2] : this.toOracleCharacter(cArray[i2]);
        }
        if (n3 < byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    @Override
    public byte[] toOracleStringWithReplacement(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (cArray[i2] >= '\ud800' && cArray[i2] < '\udc00') {
                if (i2 + 1 < n2 && cArray[i2 + 1] >= '\udc00' && cArray[i2 + 1] <= '\udfff') {
                    byArray[n3++] = this.noSurrogate ? this.m_oraCharReplacement : this.toOracleCharacterWithReplacement(cArray[i2], cArray[i2 + 1]);
                    ++i2;
                    continue;
                }
                byArray[n3++] = this.m_oraCharReplacement;
                continue;
            }
            byArray[n3++] = cArray[i2] < '\u0080' && this.strictASCII ? (byte)cArray[i2] : this.toOracleCharacterWithReplacement(cArray[i2]);
        }
        if (n3 < byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    @Override
    public void buildUnicodeToOracleMapping() {
        int n2;
        int n3;
        int n4;
        int n5;
        char[] cArray;
        Object object;
        Enumeration enumeration;
        int n6;
        int n7;
        this.m_oraCharLevel1 = new char[256];
        this.m_oraCharSurrogateLevel = null;
        this.m_oraCharLevel2 = null;
        Vector vector = new Vector(45055, 12287);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        int n8 = this.m_ucsChar.length;
        char c2 = '\u0000';
        char c3 = '\u0000';
        for (n7 = 0; n7 < 256; ++n7) {
            this.m_oraCharLevel1[n7] = 65535;
        }
        for (n7 = 0; n7 < n8; ++n7) {
            n6 = this.m_ucsChar[n7];
            if (n6 == -1) continue;
            enumeration = (Enumeration)new int[2];
            enumeration[0] = n6;
            enumeration[1] = (Enumeration)n7;
            vector.addElement(enumeration);
            this.storeMappingRange(n6, hashtable, hashtable2);
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n8 = this.extraUnicodeToOracleMapping.length;
            for (n7 = 0; n7 < n8; ++n7) {
                n6 = this.extraUnicodeToOracleMapping[n7][0];
                this.storeMappingRange(n6, hashtable, hashtable2);
            }
        }
        enumeration = hashtable.keys();
        int n9 = 0;
        int n10 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable.get(object);
            if (cArray == null) continue;
            n9 += 256;
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable2.get(object);
            if (cArray == null) continue;
            n10 += 256;
        }
        if (n9 != 0) {
            this.m_oraCharSurrogateLevel = new char[n9];
        }
        if (n10 != 0) {
            this.m_oraCharLevel2 = new char[n10 + 256];
        }
        for (n7 = 0; n7 < n9; ++n7) {
            this.m_oraCharSurrogateLevel[n7] = 65535;
        }
        for (n7 = 0; n7 < n10 + 256; ++n7) {
            this.m_oraCharLevel2[n7] = 65535;
        }
        for (n7 = 0; n7 < vector.size(); ++n7) {
            int[] nArray = (int[])vector.elementAt(n7);
            n5 = nArray[0] >> 24 & 0xFF;
            n4 = nArray[0] >> 16 & 0xFF;
            n3 = nArray[0] >> 8 & 0xFF;
            n2 = nArray[0] & 0xFF;
            if (n5 >= 216 && n5 < 220) {
                if (this.m_oraCharLevel1[n5] == '\uffff') {
                    this.m_oraCharLevel1[n5] = c3;
                    c3 = (char)(c3 + 256);
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] == '\uffff') {
                    this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] = c3;
                    c3 = (char)(c3 + 256);
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] == '\uffff') {
                    this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] = c2;
                    c2 = (char)(c2 + 256);
                }
                if (this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] + n2] != '\uffff') continue;
                this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] + n2] = (char)(nArray[1] & 0xFFFF);
                continue;
            }
            if (this.m_oraCharLevel1[n3] == '\uffff') {
                this.m_oraCharLevel1[n3] = c2;
                c2 = (char)(c2 + 256);
            }
            if (this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n2] != '\uffff') continue;
            this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n2] = (char)(nArray[1] & 0xFFFF);
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n8 = this.extraUnicodeToOracleMapping.length;
            for (n7 = 0; n7 < n8; ++n7) {
                n6 = this.extraUnicodeToOracleMapping[n7][0];
                n5 = n6 >>> 24 & 0xFF;
                n4 = n6 >>> 16 & 0xFF;
                n3 = n6 >>> 8 & 0xFF;
                n2 = n6 & 0xFF;
                if (n5 >= 216 && n5 < 220) {
                    if (this.m_oraCharLevel1[n5] == '\uffff') {
                        this.m_oraCharLevel1[n5] = c3;
                        c3 = (char)(c3 + 256);
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] == '\uffff') {
                        this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] = c3;
                        c3 = (char)(c3 + 256);
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] == '\uffff') {
                        this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] = c2;
                        c2 = (char)(c2 + 256);
                    }
                    this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] + n2] = (char)(this.extraUnicodeToOracleMapping[n7][1] & 0xFF);
                    continue;
                }
                if (this.m_oraCharLevel1[n3] == '\uffff') {
                    this.m_oraCharLevel1[n3] = c2;
                    c2 = (char)(c2 + 256);
                }
                this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n2] = (char)(this.extraUnicodeToOracleMapping[n7][1] & 0xFFFF);
            }
        }
        this.noSurrogate = this.m_oraCharSurrogateLevel == null;
        this.strictASCII = true;
        for (n7 = 0; n7 < 128; ++n7) {
            if (this.m_oraCharLevel2[n7] == n7) continue;
            this.strictASCII = false;
            break;
        }
        for (n7 = 0; n7 < 256; ++n7) {
            if (this.m_oraCharLevel1[n7] != '\uffff') continue;
            this.m_oraCharLevel1[n7] = (char)n10;
        }
        this.m_oraCharLevel2Size = n10;
    }

    @Override
    public void extractCodepoints(Vector vector) {
        int n2 = 0;
        int n3 = 255;
        for (int i2 = n2; i2 <= n3; ++i2) {
            try {
                int[] nArray = new int[]{i2, this.toUnicode((byte)i2)};
                vector.addElement(nArray);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        for (int i2 = 0; i2 < this.extraUnicodeToOracleMapping.length; ++i2) {
            int[] nArray = new int[]{this.extraUnicodeToOracleMapping[i2][0], this.extraUnicodeToOracleMapping[i2][1]};
            vector.addElement(nArray);
        }
    }

    @Override
    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    @Override
    public char getOraChar1ByteRep() {
        return (char)this.m_oraCharReplacement;
    }

    @Override
    public char getOraChar2ByteRep() {
        return '\u0000';
    }

    @Override
    public int getUCS2CharRep() {
        return this.m_ucsReplacement;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

