#ifndef STACK_H
#define STACK_H

#include <string>

using namespace std;

class Node
{
private:
   string data;
   Node* next;
friend class Stack;   
};


/**
   Implementacja stosu jako sekwencji węzłów.
*/
class Stack
{
public:   
   /** 
      Konstruuje pusty stos.
   */
   Stack();

   /**
      Dodaje element na szczyt stosu.
      @param element dodawany element
   */
   void push(string element);

   /**
      Zwraca element ze szczytu stosu.
      @return element ze szczytu
   */
   string top() const;

   /**
      Usuwa element ze szczytu stosu.
   */
   void pop();

   /**
      Zwraca liczbę elementów na stosie.
      @return rozmiar
   */
   int size() const;
  
private:   
   Node* first;
   int len;
};

#endif

