#include <fstream>
#include <iostream>
#include <iomanip>
#include <sstream>
#include <string>

using namespace std;

/**
   Sprawdza, czy w danym wierszu występują powtórzone wyrazy (np. "ten ten").
   @param line wiersz tekstu
   @return wartość true, jeśli wiersz zawiera powtórzone wyrazy
*/
bool has_repeated_words(string line)
{
   istringstream strm;
   strm.str(line); // Ten strumień łańcuchowy służy do odczytu wiersza.
   string previous_word = "";
   string word; 
   while (strm >> word) // Dla każdego wyrazu w wierszu
   {
      if (word == previous_word) // Znaleziono duplikat.
      {
         return true;
      }
      else // Zapamiętaj ten wyraz na następną iterację.
      {
         previous_word = word;
      }
   }
   return false;
}

int main()
{
   string filename;
   cout << "Wprowadź nazwę pliku: ";
   cin >> filename;
   ifstream in_file;
   in_file.open(filename);
   
   int line_number = 0;
   string line;
   while (getline(in_file, line)) // Dla każdego wiersza w pliku
   {
      line_number++;
      // Wyświetl wiersz, jeśli występują w nim powtórzone słowa.
      if (has_repeated_words(line)) 
      {
         cout << setw(7) << line_number << ":" << line << endl;
      }
   }
   return 0;
}

