#include <iostream>
#include <fstream>
#include <string>
#include <sstream>

using namespace std;

/**
   Koduje strumień szyfrem Cezara.
   @param strumień do odczytu
   @param out strumień do zapisu
   @param k klucz szyfrujący
*/
void encrypt_file(ifstream& in, ofstream& out, int k)
{  
   char ch;
   while (in.get(ch))
   {
      out.put(ch + k);
   }
}

int main(int argc, char* argv[])
{  
   int key = 3;
   int file_count = 0; // Liczba podanych plików
   ifstream in_file;
   ofstream out_file;

   for (int i = 1; i < argc; i++) // Przetwarzaj wszystkie argumenty wiersza poleceń.
   {  
      string arg = argv[i]; // Obecnie przetwarzany argument
      if (arg == "-d") // Opcja odszyfrowywania
      { 
         key = -3; 
      }
      else // Jest to nazwa pliku.
      {  
         file_count++;
         if (file_count == 1) // Pierwsza nazwa pliku
         {  
            in_file.open(arg);
            if (in_file.fail()) // Wyjdź z programu, jeśli otwarcie się nie powiodło.
            { 
               cout << "Błąd przy otwieraniu pliku wejściowego " << arg << endl;
               return 1;
            }
         }
         else if (file_count == 2) // Druga nazwa pliku
         {  
            out_file.open(arg);
            if (out_file.fail()) 
            { 
               cout << "Błąd przy otwieraniu pliku wyjściowego " << arg << endl;
               return 1;
            }
         }
      }
   }

   if (file_count != 2) // Wyjdź, jeśli użytkownik nie podał dwóch plików.
   { 
      cout << "Użycie: " << argv[0] << " [-d] plik_wejścia plik_wyjścia" << endl;
      return 1;
   }

   encrypt_file(in_file, out_file, key);
   return 0;
}

