#ifndef DIRENTRY_H
#define DIRENTRY_H

#include <string>
#include <vector>

using namespace std;

class DirectoryEntry
{
public:
   /**
      Konstruuje wpis katalogu reprezentujący katalog.
   */
   DirectoryEntry(string directory_name);
   /**
      Zwraca elementy podrzędne tego katalogu.
   */
   vector<DirectoryEntry> children() const;
   /**
      Sprawdza, czy wpis reprezentuje katalog.
   */
   bool is_directory() const;
   /**
      Zwraca nazwę wpisu.
   */
   string name() const;
   /**
      Zwraca rozszerzenie tego wpisu, lub ciąg "", jeśli ten wpis
      nie ma rozszerzenia.
   */
   string extension() const;
private:
   DirectoryEntry();
   DirectoryEntry child(string name, int childtype) const;
   
   string entryname;
   int type; 
};

#endif

