#include <iostream>
#include <iomanip>
#include "time.h"

using namespace std;

/**
   Wyznacza punkt w czasie odległy o pewną liczbę minut.
   @param a punkt w czasie
   @param minutes liczba minut do dodania
   @return punkt w czasie późniejszy o daną liczbę minut od czasu a
*/
Time operator+(Time a, int minutes)
{
   int result_minutes = a.get_hours() * 60 + a.get_minutes() + minutes;
   return Time((result_minutes / 60) % 24, result_minutes % 60);
}

/**
   Oblicza liczbę minut pomiędzy dwoma punktami w czasie.
   @param a punkt w czasie
   @param b drugi punkt w czasie
   @return liczba minut, o którą czas a różni się od czasu b
*/
int operator-(Time a, Time b)
{
   return a.get_hours() * 60 + a.get_minutes()
      - b.get_hours() * 60 - b.get_minutes();
}

/**
   Porównuje dwa punkty w czasie.
   @param a punkt w czasie
   @param b drugi punkt w czasie
   @return wartość true, jeśli są takie same
*/
bool operator==(Time a, Time b)
{
   return a - b == 0;
}

/**
   Porównuje dwa punkty w czasie.
   @param a punkt w czasie
   @param b drugi punkt w czasie
   @return wartość true, jeśli nie są takie same
*/
bool operator!=(Time a, Time b)
{
   return a - b != 0;
}

/**
   Porównuje dwa punkty w czasie.
   @param a punkt w czasie
   @param b drugi punkt w czasie
   @return wartość true, jeśli czas a jest wcześniejszy niż b
*/
bool operator<(Time a, Time b)
{
   return a - b < 0;
}

/**
   Wyświetla obiekt typu Time.
   @param out strumień wyjściowy
   @param a punkt w czasie
   @return strumień out
*/
ostream& operator<<(ostream& out, Time a)
{
   out << a.get_hours() << ":"
      << setw(2) << setfill('0')
      << a.get_minutes();
   return out;
}

/**
   Wczytuje obiekt typu Time.
   @param in strumień wejściowy
   @param a zmienna zawierająca punkt w czasie
   @return strumień in
*/
istream& operator>>(istream& in, Time& a)
{
   int hours;
   char separator;
   int minutes;
   in >> hours;
   in.get(separator); // Wczytaj znak :
   in >> minutes;
   a = Time(hours, minutes);
   return in;
}

int main()
{
   Time too_early(6, 0);
   Time wake_up = too_early + 45;
   cout << "Wstań o godzinie: " << wake_up << endl;
   cout << "Wprowadź bieżący czas: ";
   Time now;
   cin >> now;
   Time noon(12, 0);
   if (now < wake_up) { cout << "Jeszcze za wcześnie! "; }
   if (now == noon) { cout << "Pora na obiad! "; }
   cout << "Czas w minutach do obiadu: " << noon - now << endl;

   return 0;
}

