#ifndef CCC_EMPL_H
#define CCC_EMPL_H

#include <string>

using namespace std;

/**
   Podstawowa klasa pracowników, używana w wielu przykładach.
*/
class Employee
{
public:
   /**
      Konstruuje obiekt pracownika bez podanego imienia i nazwiska oraz z zerowym wynagrodzeniem.
   */
   Employee();
   /**
      Konstruuje obiekt pracownika o podanym imieniu i nazwisku oraz wynagrodzeniu.
      @param employee_name imię i nazwisko pracownika
      @param initial_salary początkowe wynagrodzenie
   */
   Employee(string employee_name, double initial_salary);
   /**
      Ustala nowe wynagrodzenie pracownika.
      @param new_salary nowa kwota wynagrodzenia
   */
   void set_salary(double new_salary);
   /**
      Pobiera wynagrodzenie pracownika.
      @return bieżące wynagrodzenie
   */
   double get_salary() const;
   /**
      Pobiera imię i nazwisko pracownika.
      @return imię i nazwisko pracownika
   */
   string get_name() const;
private:
   string name;
   double salary;
};

#endif

