#include <iostream>

using namespace std;

class BankAccount
{
public:
   BankAccount(); // Nadaje zmiennej balance wartość 0.
   BankAccount(double initial_balance); // Nadaje zmiennej balance wartość initial_balance.
   void deposit(double amount);
   void withdraw(double amount);
   double get_balance() const;
private:
   double balance;
};

BankAccount::BankAccount()
{
   balance = 0;
}

BankAccount::BankAccount(double initial_balance)
{
   balance = initial_balance;   
}

void BankAccount::deposit(double amount)
{
   balance = balance + amount;
}

void BankAccount::withdraw(double amount)
{
   balance = balance - amount;
}

double BankAccount::get_balance() const
{
   return balance;
}

int main()
{
   BankAccount joes_account;
      // Używa konstruktora domyślnego.
   BankAccount lisas_account(499.95);
      // Używa konstruktora BankAccount(double).
   cout << "Saldo konta Joego: " << joes_account.get_balance() << endl;
   cout << "Saldo konta Lisy: " << lisas_account.get_balance() << endl;
   return 0;
}

