/**
   Symulacja kasy fiskalnej, która liczy produkty
   i łączną sumę należności.
*/
class CashRegister
{
public:
   /**
      Zeruje kasę fiskalną.
   */
   void clear();
   /**
      Dodaje produkt do kasy.
      @param price cena dodawanego produktu
   */
   void add_item(double price);
   /**
      Pobiera wartość wszystkich obecnie sprzedawanych produktów.
      @return łączna wartość
   */
   double get_total() const;
   /**
      Pobiera liczbę obecnie sprzedawanych produktów.
      @return liczba produktów
   */
   int get_count() const;
private:
   int item_count;
   double total_price;
};

