#include <iostream>

using namespace std;

/**
   Odczytuje sekwencję liczb zmiennoprzecinkowych.
   @param inputs tablica zawierająca liczby
   @param capacity pojemność tej tablicy
   @return liczba danych wejściowych przechowywanych w tablicy
*/
int read_inputs(double inputs[], int capacity)
{
   int current_size = 0;
   cout << "Proszę wprowadzić liczby, W - wyjście:" << endl;
   bool done = false;
   while (!done)
   {  
      double input;
      cin >> input;
      if (cin.fail())
      {
         done = true;
      }
      else if (current_size < capacity)
      {
         inputs[current_size] = input;
         current_size++;
      }
   }
   return current_size;
}

/**
   Pobiera z tablicy najmniejszą liczbę.
   @param values częściowo wypełniona tablica o rozmiarze >= 1
   @param size liczba elementów tablicy values
   @return najmniejsza liczba w tablicy values
*/
double minimum(double values[], int size)
{
   double smallest = values[0];
   for (int i = 1; i < size; i++)
   {
      if (values[i] < smallest)
      {
         smallest = values[i];
      }
   }
   return smallest;
}

/**
   Oblicza sumę elementów tablicy.
   @param values częściowo wypełniona tablica
   @param size liczba elementów tablicy values
   @return suma elementów tablicy values
*/
double sum(double values[], int size)
{
   double total = 0;
   for (int i = 0; i < size; i++)
   {
      total = total + values[i];
   }
   return total;
}

int main()
{
   const int CAPACITY = 1000;
   double scores[CAPACITY];
   int size = read_inputs(scores, CAPACITY);
   if (size == 0)
   {
      cout << "Niezbędny jest przynajmniej jeden wynik." << endl;
   }
   else
   {
      double final_score = sum(scores, size) - minimum(scores, size); 
      cout << "Wynik końcowy: " << final_score << endl;
   }
   return 0;
}

