#include "picture.h"
#include <string>

using namespace std;

int main()
{
   const int MAX_WIDTH = 720;
   const int GAP = 10;
   const string names = "abcdefghijklmnopqrst";
   const int PICTURES = names.length();

   // Odczytaj pierwszy obraz.
   Picture pic("a.png");

   // Zmienna x to współrzędna lewej krawędzi następnego obrazu.
   int x = pic.width() + GAP;

   // Zmienna max_y zawiera największą dotychczas wartość współrzędnej y.
   int max_y = pic.height(); 
   for (int i = 1; i < PICTURES; i++)
   {
      // Odczytaj następny obraz.
      Picture pic2(names.substr(i, 1) + ".png");
      if (x + pic2.width() < MAX_WIDTH) // Obraz mieści się w bieżącym rzędzie.
      {
         pic.add(pic2, x, 0);
         // Zaktualizuj zmienne x i max_y.
         x = x + pic2.width() + GAP;
         if (pic2.height() > max_y)
         {
            max_y = pic2.height();
         }
      }
      else
      {
         // PUmieść obraz w następnym rzędzie.
         pic.add(pic2, 0, max_y + GAP);
         pic.save("gallery.png");
         return 0;
      }
   }  
}

