#ifndef PICTURE_H
#define PICTURE_H

#include "lodepng.h"
#include <string>
#include <vector>

using namespace std;

class Picture
{
 public:
   /**
      Tworzy obraz o zerowej szerokoci i wysokoci.
   */
   Picture();

   /**
      Tworzy obraz z danego pliku PNG.
      @param filename nazwa pliku okrelajca obraz PNG.
   */
   Picture(string filename);

   /**
      Tworzy obraz o jednokolorowych pikselach (domylnie
      biaych).
      @param red warto koloru czerwonego pikseli (od 0 do 255)
      @param green warto koloru zielonego pikseli (od 0 do 255)
      @param blue warto koloru niebieskiego pikseli (od 0 do 255)
      @param width szeroko obrazu
      @param height wysoko obrazu
   */
   Picture(int width, int height, int red = 255, int green = 255, int blue = 255);

   /**
      Tworzy obraz na podstawie dwuwymiarowego wektora poziomw szaroci.     @param grays the gray levels
   */
   Picture(const vector<vector<int> >& grays);

   /**
      Zwraca szeroko obrazu.
      @return szeroko
   */   
   int width() const { return _width; }

   /**
      Zwraca wysoko obrazu.
      @return wysoko
   */
   int height() const { return _height; }

   /**
      Zapisuje obraz w podanym pliku.
      @param filename nazwa pliku okrelajca obraz PNG.
   */
   void save(string filename) const;

   /**
      Zwraca warto koloru czerwonego na danej pozycji.
      @param x wsprzdna x (w pionie)
      @param y wsprzdna y (w poziomie)
      @return warto koloru czerwonego piksela (od 0 do 255)
      albo 0, jeli podany punkt nie naley do obrazu.
   */
   int red(int x, int y) const;

   /**
      Zwraca warto koloru zielonego na danej pozycji.
      @param x wsprzdna x (w pionie)
      @param y wsprzdna y (w poziomie)
      @return warto koloru zielonego piksela (od 0 do 255)
      albo 0, jeli podany punkt nie naley do obrazu.
   */
   int green(int x, int y) const;

   /**
      Zwraca warto koloru niebieskiego na danej pozycji.
      @param x wsprzdna x (w pionie)
      @param y wsprzdna y (w poziomie)
      @return warto koloru niebieskiego piksela (od 0 do 255)
      albo 0, jeli podany punkt nie naley do obrazu.
   */   
   int blue(int x, int y) const;

   /**
      Nadaje pikselowi podany kolor, w razie potrzeby
      rozszerza obraz.
      @param x wsprzdna x (w pionie)
      @param y wsprzdna y (w poziomie)
      @param red warto koloru czerwonego piksela (od 0 do 255)
      @param green warto koloru zielonego piksela (od 0 do 255)
      @param blue warto koloru niebieskiego piksela (od 0 do 255)
   */   
   void set(int x, int y, int red, int green, int blue);

   /**
      Zwraca poziomy szaroci wszystkich pikseli obrazu.
      @return dwuwymiarowa tablica wartoci szaroci (od 0 do 255)
   */
   vector<vector<int> > grays() const;

   /**
      Dodaje do obrazu na podanej pozycji drugi, w razie potrzeby
      obraz jest rozszerzany.
      @param drugi dodawany obraz
      @param x wsprzdna x (kolumna) grnego lewego rogu
      @param y wsprzdna y (wiersz) grnego lewego rogu
   */
   void add(const Picture& other, int x = 0, int y = 0);

 private:
   void ensure(int x, int y);
   
   vector<unsigned char> _values;
   int _width;
   int _height;   
};

#endif
