#include <iostream>
#include <iomanip>
#include <string>

using namespace std;

const int ROWS = 6;
const int COLUMNS = 7;

/**
   Oblicza sumę kolumny tablicy.
   @param table tablica o 7 kolumnach
   @param rows liczba wierszy w tablicy
   @param column kolumna, której sumę trzeba obliczyć
   @return suma wszystkich elementów w podanej kolumnie
*/
int column_total(int table[][COLUMNS], int rows, int column)
{
   int total = 0;
   for (int i = 0; i < rows; i++)
   {
      total = total + table[i][column];
   }
   return total;
}

int main()
{
   int data[ROWS][COLUMNS] =
   {
      { 106, 107, 111, 133, 221, 767, 1766 },
      { 502, 635, 809, 947, 1402, 3634, 5268 },
      { 2, 2, 2, 6, 13, 30, 46 },
      { 163, 203, 276, 408, 547, 729, 628 },
      { 2, 7, 26, 82, 172, 307, 392 },
      { 16, 24, 38, 74, 167, 511, 809 }
   };

   string continents[ROWS] =
      {
         "Afryka",
         "Azja",
         "Australia",
         "Europa",
         "Ameryka Północna",
         "Ameryka Poludniowa"
      };

   cout << "                 Rok 1750 1800 1850 1900 1950 2000 2050"
      << endl;

   // Wypisz dane
   for (int i = 0; i < ROWS; i++)
   {
      // Wypisz wiersz nr i
      cout << setw(20) << continents[i];
      for (int j = 0; j < COLUMNS; j++)
      {
         cout << setw(5) << data[i][j];
      }
      cout << endl; // Po zakończeniu wiersza tablicy przejdź do nowego wiersza na ekranie
   }

   // Wypisz sumy kolumn
   cout << "               Świat";
   for (int j = 0; j < COLUMNS; j++)
   {
      cout << setw(5) << column_total(data, ROWS, j);
   }
   cout << endl;

   return 0;
}

