#include <iostream>

using namespace std;

/**
   Odczytuje sekwencję liczb zmiennoprzecinkowych.
   @param inputs tablica zawierająca liczby
   @param capacity pojemność tej tablicy
   @return liczba danych wejściowych przechowywanych w tablicy
*/
int read_inputs(double inputs[], int capacity)
{
   int current_size = 0;
   cout << "Proszę wprowadzić liczby, W - wyjście:" << endl;
   bool more = true;
   while (more)
   {  
      double input;
      cin >> input;
      if (cin.fail())
      {
         more = false;
      }
      else if (current_size < capacity)
      {
         inputs[current_size] = input;
         current_size++;
      }
   }
   return current_size;
}

/**
   Mnoży wszystkie elementy tablicy przez dany czynnik.
   @param values częściowo wypełniona tablica
   @param size liczba elementów tablicy values
   @param factor liczba, przez którą mnożony jest każdy z elementów
*/
void multiply(double values[], int size, double factor)
{
   for (int i = 0; i < size; i++)
   {
      values[i] = values[i] * factor;
   }
}

/**
   Wyświetla elementy tablicy rozdzielone przecinkami.
   @param values częściowo wypełniona tablica
   @param size liczba elementów tablicy values
*/
void print(double values[], int size)
{
   for (int i = 0; i < size; i++)
   {
      if (i > 0) { cout << ", "; }
      cout << values[i];
   }
   cout << endl;
}

int main()
{  
   const int CAPACITY = 1000;
   double values[CAPACITY];
   int size = read_inputs(values, CAPACITY);
   multiply(values, size, 2);
   print(values, size);

   return 0;
}

