#include <iostream>
#include <vector>

using namespace std;

/**
   Odczytuje sekwencję liczb zmiennoprzecinkowych.
   @return wektor zawierający liczby
*/
vector<double> read_inputs()
{
   vector<double> result;
   cout << "Proszę wprowadzić liczby, W - wyjście:" << endl;
   bool done = false;
   while (!done)
   {  
      double input;
      cin >> input;
      if (cin.fail())
      {
         done = true;
      }
      else 
      {
         result.push_back(input);
      }
   }
   return result;
}

/**
   Pobiera z wektora najmniejszą liczbę.
   @param values wektor o rozmiarze >= 1
   @return najmniejszy element tablicy values
*/
double minimum(vector<double> values)
{
   double smallest = values[0];
   for (int i = 1; i < values.size(); i++)
   {
      if (values[i] < smallest)
      {
         smallest = values[i];
      }
   }
   return smallest;
}

/**
   Oblicza sumę elementów wektora.
   @param values wektor
   @return the suma liczb w wektorze values
*/
double sum(vector<double> values)
{
   double total = 0;
   for (int i = 0; i < values.size(); i++)
   {
      total = total + values[i];
   }
   return total;
}

int main()
{
   vector<double> scores = read_inputs();
   if (scores.size() == 0)
   {
      cout << "Niezbędny jest przynajmniej jeden wynik." << endl;
   }
   else
   {
      double final_score = sum(scores) - minimum(scores); 
      cout << "Wynik końcowy: " << final_score << endl;
   }
   return 0;
}

