#include <iostream>
#include <string>

using namespace std;

/**
   Zamienia ocenę wyrażoną literą (system amerykański) na liczbę.
   @param grade ocena wyrażona literą (A+, A, A-, ..., D-, F)
   @return równoważna ocena liczbowa
*/
double grade_to_number(string grade)
{
   double result = 0;
   string first = grade.substr(0, 1);
   if (first == "A") { result = 4; }
   else if (first == "B") { result = 3; }
   else if (first == "C") { result = 2; }
   else if (first == "D") { result = 1; }
   if (grade.length() > 1)
   {
      if (grade.substr(1, 1) == "+")
      {
         result = result + 0.3;
      }
      else 
      {
         result = result - 0.3;
      }
   }
   return result;
}

/**
   Konwertuje liczbę na najbliższą jej ocenę wyrażoną literą.
   @param x liczba od 0 do 4.3
   @return najbliższa ocena wyrażona literą
*/
string number_to_grade(double x)
{
   if (x >= 4.15) { return "A+"; }
   if (x >= 3.85) { return "A"; }
   if (x >= 3.5) { return "A-"; }
   if (x >= 3.15) { return "B+"; }
   if (x >= 2.85) { return "B"; }
   if (x >= 2.5) { return "B-"; }
   if (x >= 2.15) { return "C+"; }
   if (x >= 1.85) { return "C"; }
   if (x >= 1.5) { return "C-"; }
   if (x >= 1.15) { return "D+"; }
   if (x >= 0.85) { return "D"; }
   if (x >= 0.5) { return "D-"; }
   return "F";
}

/**
   Zwraca mniejszą z dwóch liczb.
   @param x jakaś liczba
   @param y jakaś liczba
   @return mniejsza z dwóch liczb x i y
*/
double min(double x, double y) 
{ 
   if (x < y) 
   { 
      return x; 
   } 
   else 
   { 
      return y; 
   }
}

/**
   Przetwarza jeden wiersz danych wejściowych.
   @return wartość true, jeśli nie napotkano wartości wartownika
*/
bool process_line()
{
   cout << "Wprowadź cztery oceny albo W, by wyjść: ";
   string g1;
   cin >> g1;
   if (g1 == "W") { return false; }
   string g2;
   string g3;
   string g4;
   cin >> g2 >> g3 >> g4;
   double x1 = grade_to_number(g1);
   double x2 = grade_to_number(g2);
   double x3 = grade_to_number(g3);
   double x4 = grade_to_number(g4);
   double xlow = min(min(x1, x2), min(x3, x4));
   double avg = (x1 + x2 + x3 + x4 - xlow) / 3;
   cout << number_to_grade(avg) << endl;
   return true;
}

int main()
{
   while (process_line())
   {
   }
   return 0;
}

