#include <iostream>
#include <cstdlib>
#include <ctime>

using namespace std;

/**
   Zwraca ciąg z jednym znakiem wylosowanym z podanego ciągu.
   @param characters ciąg, z którego ma być wylosowany znak
   @return podciąg o długości 1 wzięty z losowego indeksu
*/
string random_character(string characters)
{
   int n = characters.length();
   int r = rand() % n;
   return characters.substr(r, 1);
}
   
/**
   Wstawia jeden ciąg do drugiego na losowej pozycji.
   @param str ciąg do którego wstawiany jest drugi ciąg
   @param to_insert ciąg do wstawienia
   @return wynik wstawienia ciągu to_insert do ciągu str
*/
string insert_at_random(string str, string to_insert)
{
   int n = str.length();
   int r = rand() % (n + 1);
   return str.substr(0, r) + to_insert + str.substr(r);
}

/**
   Generuje losowe hasło.
   @param length długość hasła
   @return hasło o podanej długości z jedną cyfrą i jednym
   symbolem specjalnym
*/
string make_password(int length)
{
   string password = "";

   // Wybierz losowe litery

   for (int i = 0; i < length - 2; i++)
   {
      password = password + random_character("abcdefghijklmnopqrstuvwxyz");
   }

   // Wstaw dwa losowe znaki

   string random_digit = random_character("0123456789");
   password = insert_at_random(password, random_digit);
   string random_symbol = random_character("+-*/?!@#$%&");
   password = insert_at_random(password, random_symbol);
   return password;
}

int main()
{
   srand(time(0));
   string result = make_password(8);
   cout << result << endl;
   return 0;
}

