#include <iostream>
#include <stack>
#include "maze.h"

using namespace std;

/*
   Program ten wykorzystuje stos do znalezienia drogi z pewnej pozycji
   w labiryncie do wyjścia. Zakłada się, że w labiryncie nie ma dróg prowadzących
   w kółko, oraz, że istnieje co najmniej jedno wyjście.
*/
int main()
{
   Maze maze(vector<string> {
      "*****************************",
      "** ***                      *",
      "** *** * ********************",
      "** *** *         *          *",
      "** *** * *******   **** *****",
      "**     * ************** *****",
      "****** ******* *******  *****",
      "******         ******* ******",
      "*      ******* ******* ******",
      "* **** ******* **           *",
      "*    ********* ******* ******",
      "* ****         ***     ******",
      "************** **************"});

   int row = 5;
   int column = 8;

   stack<Path> s;
   for (Path p : maze.paths_from(row, column))
   {
      s.push(p);
   }

   while (s.size() > 0)
   {
      Path p = s.top();
      s.pop();
      cout << "Podążam droga ";
      p.print();
      int r = p.get_ending_row();
      int c = p.get_ending_column();
      if (maze.is_exit(r, c))
      {
         cout << "Wyjście!" << endl;
         return 0;
      }
      else if (maze.is_dead_end(r, c))
      {
         cout << "Ślepy koniec" << endl;
      }
      else
      {
         for (Path p2 : maze.paths_from(r, c))
         {
            if (!p2.is_opposite(p))
            {
               s.push(p2);
            }
         }
      }
   }
}

