#ifndef STRING_H
#define STRING_H

#include <iostream>

using namespace std;

class String
{
public:
   String();
   String(const char s[]);
   String(const String& other);
   String& operator=(const String& other);
   ~String();
   
   String operator+(const String& other) const;
   bool operator==(const String& other) const;

   /**
      Zwraca długość ciągu.
      @return długość
   */
   int length() const;   
   /**
      Zwraca podciąg z tego ciągu.
      @param start pozycja pierwszego znaku do skopiowania
      @param length liczba znaków do skopiowania
      @return podciąg
   */
   String substr(int start, int length) const;
   /**
      Wypisuje ten ciąg do strumienia.
      @param out strumień wyjściowy
   */
   void print(ostream& out) const;
private:
   char* buffer;
   int len;
};

ostream& operator<<(ostream& out, const String& str);
bool operator!=(const String& s, const String& t);

#endif

