#include <iostream>
#include <iomanip>
#include <string>

using namespace std;

const int COLUMNS = 3;

/**
   Oblicza sumę wiersza tablicy.
   @param table tablica o trzech kolumnach
   @param row wiersz, którego sumę trzeba obliczyć
   @return suma wszystkich elementów w podanym wierszu
*/
double row_total(int table[][COLUMNS], int row)
{
   int total = 0; 
   for (int j = 0; j < COLUMNS; j++)
   {
      total = total + table[row][j];
   }
   return total;
}

int main()
{
   const int COUNTRIES = 8;
   const int MEDALS = 3;

   string countries[] =
      {
         "Kanada",
         "Włochy",
         "Niemcy",
         "Japonia",
         "Kazachstan",
         "Rosja",
         "Korea Płd.",
         "USA"
      };
   
   int counts[COUNTRIES][MEDALS] = 
   { 
      { 0, 3, 0 },
      { 0, 0, 1 },
      { 0, 0, 1 },
      { 1, 0, 0 },
      { 0, 0, 1 },
      { 3, 1, 1 },
      { 0, 1, 0 },
      { 1, 0, 1 }
   }; 

   cout << "           Kraj   Złote Srebrne Brązowe    Suma" << endl;

   // Wyświetl kraje, liczby poszczególnych medali i sumy wierszy.
   for (int i = 0; i < COUNTRIES; i++)
   {
      cout << setw(15) << countries[i];
      // Przetwarzaj wiersz nr i.
      for (int j = 0; j < MEDALS; j++)
      {
         cout << setw(8) << counts[i][j];
      }
      int total = row_total(counts, i);
      cout << setw(8) << total << endl; 
   }

   return 0;
}

