#include <iostream>
#include <iomanip>

using namespace std;

/**
   Symulacja kasy fiskalnej, która liczy produkty
   i łączną sumę należności.
*/
class CashRegister
{
public:
   /**
      Zeruje kasę fiskalną.
   */
   void clear();
   /**
      Dodaje produkt do kasy.
      @param price cena dodawanego produktu
   */
   void add_item(double price);
   /**
      Pobiera wartość wszystkich obecnie sprzedawanych produktów.
      @return łączna wartość
   */
   double get_total() const;
   /**
      Pobiera liczbę obecnie sprzedawanych produktów.
      @return liczba produktów
   */
   int get_count() const;
private:
   int item_count;
   double total_price;
};

void CashRegister::clear()
{
   item_count = 0;
   total_price = 0;
}

void CashRegister::add_item(double price)
{
   item_count++;
   total_price = total_price + price;
}

double CashRegister::get_total() const
{
   return total_price; 
}

int CashRegister::get_count() const
{
   return item_count; 
}

/**
   Wyświetla liczbę produktów i łączną wartość na kasie.
   @param reg obiekt kasy fiskalnej do wyświetlenia
*/
void display(CashRegister reg)
{
   cout << "Produkt " << reg.get_count() << ": $"
      << fixed << setprecision(2) << reg.get_total() << endl;
}

int main()
{
   CashRegister register1;
   register1.clear();
   register1.add_item(1.95);
   display(register1);
   register1.add_item(0.95);
   display(register1);
   register1.add_item(2.50);
   display(register1);
   return 0;
}

