#include <iostream>

using namespace std;

/**
   Odczytuje sekwencję liczb zmiennoprzecinkowych.
   @param inputs tablica zawierająca liczby
   @param capacity pojemność tej tablicy
   @return liczba danych wejściowych przechowywanych w tablicy
*/
int read_inputs(double inputs[], int capacity)
{
   int current_size = 0;
   cout << "Proszę wprowadzić liczby, W - wyjście:" << endl;
   bool done = false;
   while (!done)
   {  
      double input;
      cin >> input;
      if (cin.fail())
      {
         done = true;
      }
      else if (current_size < capacity)
      {
         inputs[current_size] = input;
         current_size++;
      }
   }
   return current_size;
}

/**
   Pobiera z tablicy pozycję najmniejszej liczby.
   @param values częściowo wypełniona tablica o rozmiarze >= 1
   @param size liczba elementów tablicy values
   @return pozycja najmniejszej liczby w tablicy values
*/
int min_position(double values[], int size)
{
   int smallest_position = 0;
   for (int i = 1; i < size; i++)
   {
      if (values[i] < values[smallest_position])
      {
         smallest_position = i;
      }
   }
   return smallest_position;
}

/**
   Usuwa z tablicy element. Kolejność elementów nie jest
   zachowywana.
   @param values częściowo wypełniona tablica
   @param current_size liczba elementów tablicy values
   (zostanie zmniejszona o 1, jeśli pozycja jest prawidłowa)
   @param pos pozycja elementu do usunięcia
*/
void remove(double values[], int& current_size, int pos)
{
   if (0 <= pos && pos < current_size)
   {
      values[pos] = values[current_size - 1];
      current_size--;
   }
}

/**
   Oblicza sumę elementów tablicy.
   @param values częściowo wypełniona tablica
   @param size liczba elementów tablicy values
   @return suma elementów tablicy values
*/
double sum(double values[], int size)
{
   double total = 0;
   for (int i = 0; i < size; i++)
   {
      total = total + values[i];
   }
   return total;
}

/**
   Usuwa z tablicy najmniejszą liczbę i zwraca
   sumę pozostałych.
   @param values częściowo wypełniona tablica o rozmiarze >= 1
   @param current_size liczba elementów tablicy values (zostanie zmniejszona o 1)
   @return suma elementów tablicy values z wyjątkiem najmniejszego
*/
double final_score(double values[], int& current_size)
{
   int pos = min_position(values, current_size);
   remove(values, current_size, pos);
   return sum(values, current_size);
}

int main()
{
   const int CAPACITY = 1000;
   double scores[CAPACITY];
   int current_size = read_inputs(scores, CAPACITY);
   if (current_size == 0)
   {
      cout << "Niezbędny jest przynajmniej jeden wynik." << endl;
   }
   else
   {
      double score = final_score(scores, current_size);
      cout << "Wynik końcowy: " << score << endl;
   }
   return 0;
}

