/*
   Program ten wypisuje częstość występowania wszystkich słów zawartych w książce "Alice in Wonderland".
*/

#include <iostream>
#include <iomanip>
#include <fstream>
#include <map>
#include <string>

using namespace std;

/**
   Zmienia litery na małe i usuwa znaki nie będące literami.
   @param s ciąg
   @return a ciąg z wszystkim literami ciągu s przekształconymi na małe
*/
string clean(const string& s)
{
   string r = "";
   for (int i = 0; i < s.length(); i++)
   {
      char c = s[i];
      if ('a' <= c && c <= 'z') // Dołącz małe litery.
      {
         r = r + c;
      }
      else if ('A' <= c && c <= 'Z') // Wielkie litery zamień na małe.
      {
         c = c - 'A' + 'a';
         r = r + c;
      }
   }
   return r;
}

int main()
{
   map<string, int> frequencies;
   fstream in("alice.txt");
   string word;
   while (in >> word)
   {
      word = clean(word);

      // Pobierz iterator do starego licznika wystąpień słowa.

      auto pos = frequencies.find(word);

      // Jeśli słowo jeszcze nie wystąpiło, umieść w liczniku 1; w przeciwnym razie zwiększ go.

      if (pos == frequencies.end())
      {
         frequencies[word] = 1;
      }
      else
      {
         pos->second++;
      }
   }

   // Wyświetl wszystkie słowa i liczbę ich wystąpień.

   for (auto p = frequencies.begin(); p != frequencies.end(); p++)
   {
      cout << setw(20) << left << p->first << setw(10) << right
         << p->second << endl;
   }
   return 0;
}

