#ifndef QUEUE_H
#define QUEUE_H

#include <string>

using namespace std;

class Queue
{
public:   
   /** 
      Konstruuje pustą kolejkę.
   */
   Queue();

   /**
      Dodaje element na koniec kolejki.
      @param element dodawany element
   */
   void push(string element);

   /**
      Zwraca element z czoła kolejki.
      @return element z czoła
   */
   string front() const;

   /**
      Usuwa element z czoła kolejki.
   */
   void pop();

   /**
      Zwraca liczbę elementów w kolejce.
      @return rozmiar
   */
   int size() const;
  
private:
   void grow_if_necessary();
   
   string* buffer;
   int len;
   int capacity;
   int head;
   int tail;
};

#endif

