#ifndef LIST_H
#define LIST_H

#include <string>

using namespace std;

class List;
class Iterator;

class Node
{
public:
   /** 
      Konstruuje węzeł z podaną wartością danych.
      @param element dane, które mają być zapisane w węźle
   */
   Node(string element);
private:
   string data;
   Node* previous;
   Node* next;
friend class List;
friend class Iterator;
};

class List
{
public:
   /**
      Konstruuje pustą listę.
   */
   List();
   /**
      Dołącza do listy element.
      @param element dołączana wartość
   */
   void push_back(string element);
   /**
      Wstawia element do listy.
      @param iter pozycja, przed którą element ma być wstawiony
      @param element wstawiana wartość
   */
   void insert(Iterator iter, string element);
   /**
      Usuwa element z listy.
      @param iter pozycja do usunięcia
      @return iterator wskazujący element następny
      po usuwanym
   */
   Iterator erase(Iterator iter);
   /**
      Pobiera początkową pozycję listy.
      @return iterator wskazujący na początek listy
   */
   Iterator begin();
   /**
      Pobiera pozycję poza końcem listy.
      @return iterator wskazujący poza koniec listy
   */
   Iterator end();
private:
   Node* first;
   Node* last;
friend class Iterator;
};

class Iterator
{
public:
   /**
      Konstruuje iterator niewskazujący elementu żadnej listy.
   */
   Iterator();
   /**  
      Wyszukuje wartość na danej pozycji.
      @return wartość węzła wskazywanego przez iterator
   */
   string get() const;
   /**
      Przesuwa iterator na następny węzeł.
   */
   void next();
   /**
      Przesuwa iterator na poprzedni węzeł.
   */
   void previous();
   /**
      Porównuje dwa iteratory.
      @param other iterator porównywany z bieżącym
      @return wartość true, jeśli ten i drugi iterator są jednakowe
   */
   bool equals(Iterator other) const;
private:
   Node* position;
   List* container;
friend class List;
};

#endif

